//
//								EJEMPLO 1
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
// Leer el estado de 6 interruptores/pulsadores del entrenador conectados a RA5-RA0 y reflejar el nivel
// lgico de los mismos sobre los leds conectaqdos a RB5-RB0

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)

main()
{
  	output_b(0x0);				// Borra las salidas
	setup_adc_ports(NO_ANALOGS);	//Puerta A digital
  	set_tris_a(0b00111111);  // RA0-RA5 se configuran como entradas
  	set_tris_b(0b00000000);  // Puerta B se configura como salidas

 	while(1)
    output_b(input_a());	//El valor de la puerta A se almacena en la puerta B	
}
